﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CFBandwidth
{
    public class Linear_Regression
    {

        double[] y;
        double[] x;
        double xAvg = 0;
        double yAvg = 0;

        double v1 = 0;
        double v2 = 0;

        double a;
        double b;
        public Linear_Regression(List<double> result, List<double> sizes)
        {
            x = sizes.ToArray();
            y = result.ToArray();

            for (int i = 0; i < y.Length; i++)
            {
                xAvg += x[i];
                yAvg += y[i];
            }

            xAvg = xAvg / x.Length;
            yAvg = yAvg / y.Length;

            for (int i = 0; i < y.Length; i++)
            {
                v1 += (x[i] - xAvg) * (y[i] - yAvg);
                v2 += Math.Pow(x[i] - xAvg, 2);
            }
            a = v1 / v2;
            b = yAvg - a * xAvg;
        }

        public double getBandwidth()
        {
            //return (8 / a) / 1000; // divided by 1000 to have resoult in Mbyte/s
            return (8 / a);
        }

        public double getA()
        {
            return a/1000;
        }

        public double getB()
        {
            //return b;
            return b/1000;
        }
    }
}
